/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.ugens.UGen;

public class GranulateSteady
extends UGen {
    public UGen.UGenInput audio = new UGen.UGenInput(this, UGen.InputType.AUDIO);
    public UGen.UGenInput grainLen = new UGen.UGenInput(this, UGen.InputType.CONTROL);
    public UGen.UGenInput spaceLen = new UGen.UGenInput(this, UGen.InputType.CONTROL);
    public UGen.UGenInput fadeLen = new UGen.UGenInput(this, UGen.InputType.CONTROL);
    private boolean insideGrain;
    private float timeSinceGrainStart;
    private float timeSinceGrainStop;
    private float timeStep;
    private float grainLength = 0.01f;
    private float spaceLength = 0.02f;
    private float fadeLength = 0.0025f;
    private float minAmp = 0.0f;
    private float maxAmp = 1.0f;

    public GranulateSteady() {
        this(0.01f, 0.02f, 0.0025f, 0.0f, 1.0f);
    }

    public GranulateSteady(float f, float f2, float f3) {
        this(f, f2, f3, 0.0f, 1.0f);
    }

    public GranulateSteady(float f, float f2, float f3, float f4, float f5) {
        this.setAllParameters(f, f2, f3, f4, f5);
        this.insideGrain = true;
        this.timeSinceGrainStart = 0.0f;
        this.timeSinceGrainStop = 0.0f;
        this.timeStep = 0.0f;
    }

    @Override
    protected void sampleRateChanged() {
        this.timeStep = 1.0f / this.sampleRate();
    }

    public void setAllTimeParameters(float f, float f2, float f3) {
        this.setAllParameters(f, f2, f3, this.minAmp, this.maxAmp);
    }

    public void setAllParameters(float f, float f2, float f3, float f4, float f5) {
        this.grainLen.setLastValue(f);
        this.spaceLen.setLastValue(f2);
        this.fadeLen.setLastValue(f3);
        this.grainLength = f;
        this.spaceLength = f2;
        this.fadeLength = f3;
        this.minAmp = f4;
        this.maxAmp = f5;
    }

    public void reset() {
        this.timeSinceGrainStart = 0.0f;
        this.insideGrain = true;
        this.grainLength = this.grainLen.getLastValue();
        this.checkFadeLength();
        this.fadeLength = this.fadeLen.getLastValue();
        this.checkFadeLength();
    }

    private void checkFadeLength() {
        this.fadeLength = Math.min(this.fadeLength, this.grainLength / 2.0f);
    }

    @Override
    protected void uGenerate(float[] fArray) {
        if (this.insideGrain) {
            float f = this.maxAmp;
            if (this.timeSinceGrainStart < this.fadeLength) {
                f *= this.timeSinceGrainStart / this.fadeLength;
            } else if (this.timeSinceGrainStart > this.grainLength - this.fadeLength) {
                f *= (this.grainLength - this.timeSinceGrainStart) / this.fadeLength;
            }
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = f * this.audio.getLastValues()[i];
            }
            this.timeSinceGrainStart += this.timeStep;
            if (this.timeSinceGrainStart > this.grainLength) {
                this.timeSinceGrainStop = 0.0f;
                this.insideGrain = false;
                this.spaceLength = this.spaceLen.getLastValue();
            }
        } else {
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = this.minAmp;
            }
            this.timeSinceGrainStop += this.timeStep;
            if (this.timeSinceGrainStop > this.spaceLength) {
                this.reset();
            }
        }
    }
}

